<?php


require_once "../../../controladores/caja.controlador.php";
require_once "../../../modelos/caja.modelo.php";

require_once "../../../controladores/plantilla.controlador.php";
require_once "../../../modelos/configuracion.modelo.php";

// require_once "../../../controladores/productos.controlador.php";
// require_once "../../../modelos/productos.modelo.php";

class imprimirEstadoCuenta{

public $idservicios;

public function traerImpresionEstadoCuenta(){

	date_default_timezone_set("America/Lima");
setlocale(LC_ALL, 'spanish');

//TRAEMOS LA INFORMACIÓN DE LA VENTA
$plantilla = new ControladorPlantilla();
$configuracionArray = $plantilla -> ctrConfiguracion();
if(!is_array($configuracionArray) || empty($configuracionArray)){
	die("Error: No se pudo cargar la configuración.");
}
$configuracion = $configuracionArray[0];
$logo = $configuracion['logo'];
$razon_social = $configuracion['razon_social'];
$prefijo =  $configuracion['prefijo'];
$celular =  $configuracion['celular'];
$email =  $configuracion['email'];
$direccion =  $configuracion['direccion'];
$nombreEmpresa = "$razon_social <br>Celular: $prefijo $celular <br> Correo: $email <br> Dirección: $direccion";


$valorContrata = $this->idservicios;
$datosCaja = ControladorCaja::ctrConsultarCaja($valorContrata, "Cerrado");
 
session_start();
$nombre = $_SESSION['nombre'];
$fechaRegistro = $datosCaja['caja']['fechaRegistro'];
$fechaCierre = $datosCaja['caja']['fechaCierre'];
$importeInicial = number_format($datosCaja['caja']['AperturaCaja'],2,'.',',');
$totalComercial = number_format($datosCaja['totalComercial'],2,'.',',');
$totalDomicilio = number_format($datosCaja['totalDomiciliar'],2,'.',',');
$ingresoBruto = number_format($datosCaja['caja']['totalIngreso'],2,'.',',');
$TotalingresoBruto = number_format($datosCaja['ingresoBruto'],2,'.',',');
$totalEntregado = number_format($datosCaja['caja']['totalEntregado'],2,'.',',');
$saldoSiguiente = number_format($datosCaja['caja']['saldoSigiente'],2,'.',',');

//exit;
//REQUERIMOS LA CLASE TCPDF

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

// ---------------------------------------------------------

$bloque1 = <<<EOF

	<table>
		
		<tr>
			
			<td style="width:200px">
	<div>
	<br>
	<img src="../../../$logo" style="width: 140px;">
	</div>
	</td>

	<td style="width:160px">
		
		<div style="font-size:12px; line-height:15px;">
			<br><br>
		$nombreEmpresa

		</div>

	</td>

			

			<td style="width:250px; text-align:center; color:red">
				<br><br><br>ESTADO N°.
				<br>112212</td>

		</tr>
		

	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------

$bloque3 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>
			<td></td>
			<td></td>
		</tr>

		<tr>

		<td style="border-botton: 1px solid #666666; background-color:white; width:400px;"><b>Fecha Registro: $fechaRegistro</b></td>
		<td style="border-botton: 1px solid #666666; background-color:white; width:143px; text-align:center"></td>
		</tr>

		<tr>
		<td style="border-botton: 1px solid #666666; background-color:white; width:400px;"><b>Fecha Cierre: $fechaCierre</b></td>
		
		<td style="border-botton: 1px solid #666666; background-color:white; width:143px; text-align:center"></td>
		</tr>
		

		<tr>

		<td style="border-botton: 1px solid #666666; background-color:white; width:400px;"><b>Estado: Cierre</b></td>
		
		<td style="border-botton: 1px solid #666666; background-color:white; width:143px; text-align:center"></td>
		
		</tr>

		<tr>
		<td style="border-botton: 1px solid #666666; background-color:white; width:400px;"><b>Nombres: $nombre</b></td>
		
		<td style="border-botton: 1px solid #666666; background-color:white; width:143px; text-align:center"></td>
		</tr>

	</table>
	
EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// ---------------------------------------------------------

//se modificaron las columnas

$bloque3 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">
		<tr>
			<td style="border-botton: 1px solid #666666; background-color:white; width:400px;"></td>
			<td style="border-botton: 1px solid #666666; background-color:white; width:143px; text-align:center"></td>
		</tr>

		<tr>

		<td style="border-botton: 1px solid #666666; background-color:white; width:400px;"><b>Concepto</b></td>
		
		<td style="border-botton: 1px solid #666666; background-color:white; width:143px; text-align:center"><b>Movimiento</b></td>

	

		</tr>

		

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// -------------------------------------------------

// Aqui  hace el ciclo para agregar las filas 
$total = 0;

$bgcolors = '<hr />';

$pdf->writeHTML($bgcolors, true, false, true, false, '');

$bloque4 = <<<EOF

 	<table style="font-size:10px; padding:5px 0px;">

	 	<tr>
 			<td style="color:#333; background-color:white; width:400px;"><b>
 				Apertura de caja:</b>
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
			 
 			</td>

 		</tr>
		 <tr>
 			<td style="color:#333; background-color:white; width:400px;">
 				Importe Inicial:
				 <br>
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
			 $importeInicial
 			</td>
			
 		</tr>
		

 	</table>


EOF;
$pdf->writeHTML($bloque4, false, false, false, false, '');

$bloque5 = <<<EOF

 	<table style="font-size:10px; padding:5px 0px;">

 		<tr>
 			<td style="color:#333; background-color:white; width:400px;"><b>
 				Ingreso del dia en:</b>
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
			 
 			</td>

 		</tr>

		<tr>
 			<td style="color:#333; background-color:white; width:400px;">
 				Total Comercial:
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
				$totalComercial
 			</td>

 		</tr>

		 <tr>
 			<td style="color:#333; background-color:white; width:400px;">
 				Total Domiciliario:
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
				$totalDomicilio
 			</td>

 		</tr>
		 <tr>
 			<td style="color:#333; background-color:white; width:400px;">
 				Total ingreso:
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
			 $ingresoBruto
 			</td>

 		</tr>
		 <tr>
 			<td style="color:#333; background-color:white; width:400px;">
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
			
 			</td>

 		</tr>

		 

		 <tr>
 			<td style="color:#333; background-color:white; width:400px;">
 				<b>Resumen del ingreso del día:</b>
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
			 
 			</td>

 		</tr>

		 <tr>
		 <td style="color:#333; background-color:white; width:400px;">
			 Total ingreso bruto:
		 </td>
		
		 <td style="color:#333; background-color:white; width:143px; text-align:center">
		 	$TotalingresoBruto
		 </td>

	 	</tr>

		 <tr>
 			<td style="color:#333; background-color:white; width:400px;">
 				Total entregado:
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">	
			$totalEntregado
 			</td>

 		</tr>

		 <tr>
 			<td style="color:#333; background-color:white; width:400px;">
 				Saldo siguiente:
 			</td>
			
 			<td style="color:#333; background-color:white; width:143px; text-align:center">
				$saldoSiguiente
 			</td>

 		</tr>

 	</table>


EOF;
$pdf->writeHTML($bloque5, false, false, false, false, '');

$bloque6 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">
		<tr>

			<td style="width:460px"></td>

			<td style="width:80px; text-align:center"></td>

		</tr>

		<tr>

		<td style="border: 1px solid #666666; background-color:white; width:460px"><b>Total</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>$saldoSiguiente</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');



//SALIDA DEL ARCHIVO 

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('Estado_Cuenta.pdf');

}

}

$factura = new imprimirEstadoCuenta();
$factura -> idservicios = base64_decode($_GET["idservicios"]);
$factura -> traerImpresionEstadoCuenta();

?>